
;*****************************************************************************************
;    Fichier requis: P16F648A.inc 
;*****************************************************************************************
 
	LIST      p=16F648A           ; Dfinition de processeur
	#include <p16F648A.inc>       ; Dfinitions des constantes

	__CONFIG _CP_OFF & _BODEN_OFF & _PWRTE_ON  & _WDT_OFF & _LVP_OFF & _MCLRE_OFF & _XT_OSC

;_CP_OFF   : pas de protection du code
;_BODEN_ON : reset du PIC si tension alim en dessous seuil ?
;_WDT_OFF  : pas de watchdog
;_PWRTE_ON : attendre 72ms aprs mise sous tension
;_LVP_OFF  : pas de mode programmation basse tension
;_MCLRE_ON : reset du PIC lors de la mise sous tension
;_MCLRE_OFF: reset du PIC en interne, RA5 est configure en entre
;_XT_OSC   : quartz 2 et 4 MHz
;_HS_OSC   : quartz 8 et 16 MHz
;_INTRC_OSC_NOCLKOUT : oscillateur interne

	ERRORLEVEL	-302
	ERRORLEVEL	-305
	ERRORLEVEL	-306
;*********************************************************************
;                        ASSIGNATIONS                          
;*********************************************************************

OPTION_val	EQU	b'11000001'
								; Rsistances pull-up dsatives(1)/actives(0)
								; Interrupt flanc montant RB0 (1)
								; selection horloge en interne (0) sinon sur RA4 (1)
								; incrementation TMR0 sur front montant (0)
								; Prescaler sur timer0 (0) sur WDT (1)
								; reglage du prescaler sur 256 (0111)
								; RBPU (bit7) dsactivation auto quand le PORT est en sortie
STATUS_val	equ	b'00000000'
INTCON_val	equ	b'11000000' 	;interr globale autorisee
TRISA_val	equ	b'00001111'
TRISB_val	equ	b'10000001'		;
PCON_val	equ	b'00001000'	
PIE1_val	equ	b'00000000'		;
PIR1_val	equ	b'00000000'		;
CMCON_val	equ	b'00000111'		;
VRCON_val	equ	b'00110000'		;rfrence tension pour comparateurs



;**************************************
;		DEFINE
;**************************************


;**************************************
;		MACRO
;**************************************

bank0	macro
		bcf	STATUS,RP0
		bcf	STATUS,RP1
		endm

bank1	macro
		bsf	STATUS,RP0
		bcf	STATUS,RP1
		endm

bank2	macro
		bcf	STATUS,RP0
		bsf	STATUS,RP1
		endm

bank3	macro
		bsf	STATUS,RP0
		bsf	STATUS,RP1
		endm	

;;;;;;;;;;;;;;;;;;;;;;;; MACRO TMR1 ;;;;;;;;;;;;;;;;;;;;;;;


;;;;;;;;;;;;;;;;;;;;;;;; MACRO TMR0 ;;;;;;;;;;;;;;;;;;;;;;;
						
activer_interr_TMR0		macro
						bsf	INTCON,5
						bank0
						endm
effacer_flag_TMR0		macro
						bcf	INTCON,2
						endm
						
;;;;;;;;;;;;;;;;;;;;;;;; MACRO RB0 ;;;;;;;;;;;;;;;;;;;;;;;
effacer_flag_RB0	macro
					bcf	INTCON,1
					endm

activer_interr_RB0	macro
					bsf	INTCON,4					
					endm
desactiver_interr_RB0	macro
						bcf	INTCON,4					
						endm

front_montant_RB0	macro
					bank1
					bsf	OPTION_REG,6
					bank0
					endm
front_descendant_RB0	macro
						bank1
						bcf	OPTION_REG,6
						bank0
						endm


recharger_nbre_sonnerie	macro
						movlw	val_nbre_sonnerie
						movwf	nbre_sonnerie
						endm
						

					
;:::::::::::::::  interr RB  :::::::::::::::::::::

activer_interr_RB	macro
					bsf		INTCON,3
					endm

desactiver_interr_RB	macro
						bcf		INTCON,3
						endm
						
effacer_flag_RB 	macro
					bank0 ;selectionner banque 0
					btfsc PORTB,1 ;avant d'effacer le flag RBIF il faut lire
					nop
					bcf INTCON,0 ;le PORTB
					endm 






;*********************************************************************
;                   DECLARATIONS DE VARIABLES                        *
;*********************************************************************

;exemples
;---------

	CBLOCK 0x20   		; dbut de la zone variables
	;ENDC
	
	;UDATA	0x20


	w_temp			:	1
	status_temp 	:	1		; zone de 1 byte
	PDel0			:	1
	PDel1			:	1
	PDel2			:	1
	t1	:	1
	t2	:	1


	ENDC

;**********************************************************************
;                      DEMARRAGE SUR RESET                            *
;**********************************************************************

			org 	0x000 		; Adresse de dpart aprs reset 	    	
			goto	init		; Adresse 0: initialiser

  
;**********************************************************************
;                     ROUTINE INTERRUPTION                            *
;**********************************************************************

			;sauvegarder registres	
			;---------------------
	org 	0x004		; adresse d'interruption
	movwf   w_temp  	; sauver registre W
	swapf	STATUS,w	; swap status avec rsultat dans w
	movwf	status_temp	; sauver status swapp
	
	;+++++++++++++++++++++++++++++++++++++++++++
	
	;  pour essai  
	
	bsf		PORTA,4
	movlw	14
	movwf	t1
	movlw	72
	movwf	t2
	call	tempo
	bcf		PORTA,4
	
attente0	btfss	PORTB,7
			goto	suite
			goto	attente0
			
suite		effacer_flag_RB
			goto	fin_interr
	
			


;+++++++++++++++++++++++++++++++++++++++++++
			;restaurer registres
			;-------------------

fin_interr	swapf	status_temp,w	
			movwf	STATUS	 
			swapf	w_temp,f	           	
			swapf	w_temp,w
			retfie  	

;*********************************************************************
;                       INITIALISATIONS                              *
;*********************************************************************

init	bank1				; slectionner banque 1
		clrf	EEADR		; permet de diminuer la consommation
		movlw	OPTION_val	; charger masque
		movwf	OPTION_REG	; initialiser registre option
		movlw	TRISA_val
		movwf	TRISA
		movlw	TRISB_val
		movwf	TRISB
		movlw	PIE1_val
		movwf	PIE1
		bank0				; Slectionner banque 0
		clrf	PORTA		; Sorties portA  0
		clrf	PORTB		; sorties portB  0
		movlw	INTCON_val	; masque interruption
		movwf	INTCON		; charger interrupt control
		movlw	PIR1_val	
		movwf	PIR1
		movlw	b'00000111'	;dsactiver comparateurs
		addwf	CMCON
		
;**************************  effacement de toute la RAM  **************************
init1	movlw	0x20
		movwf	FSR
ini		clrf	INDF
		incf	FSR,1
		movlw	0x80
		subwf	FSR,0
		btfss	STATUS,Z
		goto	ini		
		
;**************************  fin d'effacement de la RAM  **************************

	
;TTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTT
;									PROGRAMME PRINCIPAL	
;TTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTT
	
	


	effacer_flag_RB
	activer_interr_RB
	effacer_flag_RB0
	desactiver_interr_RB0	

	
debut				nop
					goto	debut



				

;FINFINFINFINFINFINFINFINFINFINFINFINFINFINFINFINFINFINFINFINFINFINFINFINFINFINFINFIN
;								FIN DU	PROGRAMME PRINCIPAL	
;FINFINFINFINFINFINFINFINFINFINFINFINFINFINFINFINFINFINFINFINFINFINFINFINFINFINFINFIN




;&&&&&&&&&&&&&&&&&&&&&&&&&&& TEMPORISATIONS &&&&&&&&&&&&&&&&&&&&&&&&&&&
         
        
;;;;;;;;;;;;;;;;;;;  tempo 1s ;;;;;;;;;;;;;;;;;;;
;	1ms	  avec 1 1 247
;	10ms  avec 1 10 247
;	20ms  avec 1 20 247		
; 	71ms  avec .1 .1 .247 
;	142ms avec .2 .72 .247
; 	1s    avec .14 .72 .247
;	2s    avec .28 .72 .247
;	3s    avec .42 .72 .247
;	4s    avec .56 .72 .247
;	5s    avec .70 .72 .247


tempo 		movf     t1,0		      
        	movwf     PDel0     
inter_0  	movf     t2,0     
       	 	movwf     PDel1     
inter_1		movlw     .247      
        	movwf     PDel2     
inter_2  	clrwdt              
        	decfsz    PDel2, 1  
        	goto      inter_2    
        	decfsz    PDel1,  1 
        	goto      inter_1    
        	decfsz    PDel0,  1 
        	goto      inter_0    
inter_3  	goto 	  inter_4         
inter_4  	clrwdt              
        	return              
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;






			
	END

